import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
  darkMode: 'class',

  content: [
    './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
    './storage/framework/views/*.php',
    './resources/views/**/*.blade.php',
    './resources/js/**/*.jsx',
  ],

  theme: {
    extend: {
      fontFamily: {
        sans: ['Figtree', ...defaultTheme.fontFamily.sans],
      },
      colors: {
        primary: {
          DEFAULT: '#001952',   // azul institucional (navy)
          50: '#f2f6ff',
          100: '#dae4ff',
          200: '#b3c6ff',
          300: '#809fff',
          400: '#4d77ff',
          500: '#1a4fff',
          600: '#0038cc',
          700: '#002699',
          800: '#001952',
          900: '#000d33',
          950: '#00081f',
        },
        secondary: {
          DEFAULT: '#e1002a',   // rojo RMIT
          50: '#fff0f2',
          100: '#ffd9dc',
          200: '#ffadb5',
          300: '#ff7a87',
          400: '#ff4759',
          500: '#e1002a',
          600: '#c90026',
          700: '#a0001f',
          800: '#7a0018',
          900: '#520011',
          950: '#3b000c',
        },
        neutral: {
          50: '#f9fafb',
          100: '#f3f4f6',
          200: '#e5e7eb',
          300: '#d1d5db',
          400: '#9ca3af',
          500: '#6b7280',
          600: '#4b5563',
          700: '#374151',
          800: '#1f2937',
          900: '#111827',
          950: '#0a0f1a',
        },
      },
    },
  },

  plugins: [forms],
};
