import { Link } from "@inertiajs/react";
import { motion } from "framer-motion";
import { FiUsers, FiArrowRight, FiLayers, FiCalendar, FiAward } from "react-icons/fi";

function ProyectoListItem({ p, index }) {
  const isEjecucion = p.estado === "En ejecución";
  const isPropuesta = p.estado === "Propuesta";

  return (
    <motion.div
      initial={{ opacity: 0, x: -20 }}
      animate={{ opacity: 1, x: 0 }}
      transition={{ duration: 0.4, delay: index * 0.05 }}
      className="group relative bg-white border-2 border-slate-200 hover:border-blue-900 hover:shadow-md transition-all overflow-hidden"
    >
      <div className="p-6 sm:p-8">
        <div className="flex flex-col lg:flex-row lg:items-start gap-6">
          {/* Contenido principal */}
          <div className="flex-1 min-w-0">
            <div className="flex items-start gap-4 mb-4">
              <div className="flex-1">
                <div className="flex items-start justify-between gap-3 mb-3">
                  <h3 className="text-xl sm:text-2xl font-serif font-bold text-slate-900 group-hover:text-blue-900 transition-colors">
                    {p.titulo}
                  </h3>

                  {p.estado && (
                    <span
                      className={[
                        "flex-shrink-0 text-xs font-bold px-3 py-1.5 uppercase tracking-wide border-2",
                        isEjecucion
                          ? "bg-blue-50 text-blue-900 border-blue-900"
                          : isPropuesta
                          ? "bg-slate-100 text-slate-700 border-slate-400"
                          : "bg-slate-50 text-slate-600 border-slate-300",
                      ].join(" ")}
                    >
                      {p.estado}
                    </span>
                  )}
                </div>

                {p.periodo && (
                  <div className="flex items-center gap-2 text-sm text-slate-600 mb-4">
                    <FiCalendar className="w-4 h-4" strokeWidth={1.5} />
                    <span className="font-medium">{p.periodo}</span>
                  </div>
                )}
              </div>
            </div>

            {p.resumen && (
              <p className="text-slate-700 leading-relaxed mb-6 text-sm sm:text-base font-light border-l-2 border-slate-300 pl-4">
                {p.resumen}
              </p>
            )}

            {/* Meta información */}
            <div className="grid sm:grid-cols-2 gap-6 mb-6">
              {/* Equipo */}
              {(p.directores?.length > 0 || p.colaboradores?.length > 0) && (
                <div>
                  <h4 className="text-xs font-bold text-slate-700 uppercase tracking-wider mb-3 flex items-center gap-2">
                    <FiUsers className="w-4 h-4" strokeWidth={2} /> Equipo de Investigación
                  </h4>
                  <div className="space-y-2">
                    {p.directores?.slice(0, 2).map((d, i) => (
                      <div key={`dir-${i}`} className="text-sm">
                        <span className="text-slate-600 font-light">{d.rol}:</span>{" "}
                        <span className="text-slate-900 font-medium">{d.nombre}</span>
                      </div>
                    ))}
                    {(p.directores?.length + (p.colaboradores?.length || 0)) > 2 && (
                      <div className="text-xs text-slate-500 font-medium">
                        +{(p.directores?.length || 0) + (p.colaboradores?.length || 0) - 2} colaboradores adicionales
                      </div>
                    )}
                  </div>
                </div>
              )}

              {/* Línea */}
              {p.linea && (
                <div>
                  <h4 className="text-xs font-bold text-slate-700 uppercase tracking-wider mb-3 flex items-center gap-2">
                    <FiLayers className="w-4 h-4" strokeWidth={2} /> Línea de Investigación
                  </h4>
                  <span className="inline-flex items-center gap-2 text-sm font-medium px-4 py-2 bg-slate-100 text-slate-800 border border-slate-300">
                    {p.linea}
                  </span>
                </div>
              )}
            </div>

            {/* ODS */}
            {p.ods && p.ods.length > 0 && (
              <div className="pt-6 border-t-2 border-slate-200">
                <h4 className="text-xs font-bold text-slate-700 uppercase tracking-wider mb-3 flex items-center gap-2">
                  <FiAward className="w-4 h-4" strokeWidth={2} /> Objetivos de Desarrollo Sostenible
                </h4>
                <div className="flex flex-wrap gap-2">
                  {p.ods.map((o) => (
                    <span
                      key={o}
                      className="text-xs px-3 py-2 bg-slate-100 text-slate-700 border border-slate-300 font-medium"
                    >
                      {o}
                    </span>
                  ))}
                </div>
              </div>
            )}
          </div>

          {/* CTA lateral */}
          <div className="flex lg:flex-col gap-3 lg:items-end lg:justify-start">
            <Link
              href={p.link || `/proyectos/${p.id}`}
              className="group/link inline-flex items-center justify-center gap-2 px-6 py-3 bg-blue-900 hover:bg-blue-800 text-white font-medium text-sm transition-all hover:shadow-md whitespace-nowrap uppercase tracking-wide"
            >
              Ver Detalles
              <FiArrowRight className="w-4 h-4 group-hover/link:translate-x-1 transition-transform" strokeWidth={2} />
            </Link>
          </div>
        </div>
      </div>

      {/* Barra lateral institucional */}
      <div
        className={[
          "absolute left-0 top-0 bottom-0 w-2",
          isEjecucion
            ? "bg-blue-900"
            : isPropuesta
            ? "bg-slate-600"
            : "bg-slate-400",
        ].join(" ")}
      />

      {/* Indicador hover inferior */}
      <div className="absolute bottom-0 left-0 w-full h-1 bg-blue-900 transform scale-x-0 group-hover:scale-x-100 transition-transform origin-left" />
    </motion.div>
  );
}

export default ProyectoListItem;
