import { Link } from "@inertiajs/react";
import { motion } from "framer-motion";
import { FiUsers, FiArrowRight, FiLayers, FiCalendar } from "react-icons/fi";

function ProyectoCard({ p, index }) {
  const isEjecucion = p.estado === "En ejecución";
  const isPropuesta = p.estado === "Propuesta";

  return (
    <motion.div
      initial={{ opacity: 0, y: 20 }}
      animate={{ opacity: 1, y: 0 }}
      transition={{ duration: 0.4, delay: index * 0.05 }}
      whileHover={{ y: -6 }}
      className="group relative border-2 border-slate-200 bg-white hover:border-blue-900 hover:shadow-lg transition-all overflow-hidden"
    >
      {/* Barra superior institucional */}
      <div
        className={[
          "h-2 w-full",
          isEjecucion ? "bg-blue-900" : isPropuesta ? "bg-slate-600" : "bg-slate-400",
        ].join(" ")}
      />

      {/* Contenido */}
      <div className="p-6">
        {/* Título + Estado */}
        <div className="flex items-start justify-between gap-3 mb-4">
          <h3 className="text-xl font-serif font-bold text-slate-900 leading-tight group-hover:text-blue-900 transition-colors">
            {p.titulo}
          </h3>

          {p.estado && (
            <span
              className={[
                "flex-shrink-0 text-xs font-bold px-3 py-1.5 uppercase tracking-wide border-2",
                isEjecucion
                  ? "bg-blue-50 text-blue-900 border-blue-900"
                  : isPropuesta
                  ? "bg-slate-100 text-slate-700 border-slate-400"
                  : "bg-slate-50 text-slate-600 border-slate-300",
              ].join(" ")}
            >
              {p.estado}
            </span>
          )}
        </div>

        {/* Periodo */}
        {p.periodo && (
          <div className="flex items-center gap-2 text-sm text-slate-600 mb-4 font-light">
            <FiCalendar className="w-4 h-4" strokeWidth={1.5} />
            <span className="font-medium">{p.periodo}</span>
          </div>
        )}

        {/* Resumen */}
        {p.resumen && (
          <p className="text-slate-700 text-sm leading-relaxed mb-5 line-clamp-3 font-light">
            {p.resumen}
          </p>
        )}

        {/* Línea de investigación */}
        {p.linea && (
          <div className="mb-4">
            <span className="inline-flex items-center gap-2 text-xs font-medium px-3 py-2 bg-slate-100 text-slate-800 border border-slate-300">
              <FiLayers className="w-3.5 h-3.5" strokeWidth={2} /> {p.linea}
            </span>
          </div>
        )}

        {/* Equipo */}
        {p.directores && p.directores.length > 0 && (
          <div className="mb-5 pb-5 border-b border-slate-200">
            <div className="flex items-start gap-2 text-sm">
              <FiUsers className="w-4 h-4 text-slate-500 mt-0.5 flex-shrink-0" strokeWidth={1.5} />
              <div>
                <div className="text-slate-900 font-medium">
                  {p.directores[0].nombre}
                </div>
                {p.directores.length > 1 && (
                  <div className="text-slate-600 text-xs mt-1 font-light">
                    +{p.directores.length - 1} colaborador{p.directores.length - 1 > 1 ? 'es' : ''}
                  </div>
                )}
              </div>
            </div>
          </div>
        )}

        {/* ODS */}
        {p.ods && p.ods.length > 0 && (
          <div className="flex flex-wrap gap-2 mb-5">
            {p.ods.slice(0, 2).map((o) => (
              <span
                key={o}
                className="text-xs px-3 py-1.5 bg-slate-100 text-slate-700 border border-slate-300 font-medium"
              >
                {o}
              </span>
            ))}
            {p.ods.length > 2 && (
              <span className="text-xs px-3 py-1.5 bg-slate-50 text-slate-600 border border-slate-200 font-medium">
                +{p.ods.length - 2}
              </span>
            )}
          </div>
        )}

        {/* CTA académico */}
        <Link
          href={p.link || `/proyectos/${p.id}`}
          className="group/link inline-flex items-center gap-2 text-blue-900 hover:text-blue-800 font-medium text-sm transition-all uppercase tracking-wide"
        >
          Ver Detalles
          <FiArrowRight className="w-4 h-4 group-hover/link:translate-x-1 transition-transform" strokeWidth={2} />
        </Link>
      </div>

      {/* Indicador hover */}
      <div className="absolute bottom-0 left-0 w-full h-1 bg-blue-900 transform scale-x-0 group-hover:scale-x-100 transition-transform origin-left" />
    </motion.div>
  );
}

export default ProyectoCard;
