// resources/js/Pages/Auth/Login.jsx
import React, { useEffect, useState } from "react";
import { Head, Link, useForm } from "@inertiajs/react";
import { FiMail, FiLock, FiLogIn, FiEye, FiEyeOff } from "react-icons/fi";
import PublicLayout from "@/Layouts/PublicLayout";

export default function Login({ status, canResetPassword }) {
  const { data, setData, post, processing, errors, reset } = useForm({
    email: "",
    password: "",
    remember: false,
  });

  const [showPwd, setShowPwd] = useState(false);

  useEffect(() => () => reset("password"), []);

  const submit = (e) => {
    e.preventDefault();
    post(route("login"));
  };

  return (
    <PublicLayout title="Acceso">


      {/* Hero sólido (solo primary) */}
      <section className="bg-primary-700 text-white">
        <div className="max-w-7xl mx-auto px-6 py-10">
          <h1 className="text-3xl md:text-4xl font-bold">Acceso</h1>
          <p className="text-primary-100 mt-2">
            Inicia sesión para gestionar y consultar proyectos.
          </p>
        </div>
        {/* Separador fino solo secondary */}
        <div className="h-1 w-full bg-secondary-600" />
      </section>

      {/* Card de login (fondo blanco, bordes en secondary) */}
      <section className="max-w-xl mx-auto px-6">
        <div className="relative -mt-10">
          <div className="mx-auto max-w-xl rounded-2xl bg-white shadow-xl border border-secondary-200 p-6 md:p-8
                          dark:bg-[#0f1115] dark:border-primary-700/40">
            {/* Estado (opcional) — solo secondary */}
            {status && (
              <div className="mb-4 rounded-md bg-secondary-50 px-4 py-2 text-sm font-medium text-secondary-800 dark:bg-secondary-700/20 dark:text-secondary-300">
                {status}
              </div>
            )}

            <form onSubmit={submit} className="space-y-5" noValidate>
              {/* Email */}
              <div>
                <label htmlFor="email" className="block text-sm font-medium text-gray-700 dark:text-gray-200">
                  Correo electrónico
                </label>
                <div className="mt-1 relative">
                  <FiMail className="absolute left-3 top-2.5 text-gray-400 pointer-events-none" />
                  <input
                    id="email"
                    type="email"
                    name="email"
                    value={data.email}
                    onChange={(e) => setData("email", e.target.value)}
                    autoComplete="username"
                    placeholder="tucorreo@ejemplo.com"
                    className="block w-full rounded-lg border border-gray-300 pl-10 pr-3 py-2
                               focus:outline-none focus:ring-2 focus:ring-primary-600 focus:border-primary-600
                               dark:bg-[#0b0e13] dark:border-gray-700 dark:text-gray-100 dark:placeholder-gray-400"
                    required
                  />
                </div>
                {errors.email && (
                  <p className="mt-2 text-sm text-red-600 dark:text-red-400">{errors.email}</p>
                )}
              </div>

              {/* Password */}
              <div>
                <label htmlFor="password" className="block text-sm font-medium text-gray-700 dark:text-gray-200">
                  Contraseña
                </label>
                <div className="mt-1 relative">
                  <FiLock className="absolute left-3 top-2.5 text-gray-400 pointer-events-none" />
                  <input
                    id="password"
                    type={showPwd ? "text" : "password"}
                    name="password"
                    value={data.password}
                    onChange={(e) => setData("password", e.target.value)}
                    autoComplete="current-password"
                    placeholder="••••••••"
                    className="block w-full rounded-lg border border-gray-300 pl-10 pr-10 py-2
                               focus:outline-none focus:ring-2 focus:ring-primary-600 focus:border-primary-600
                               dark:bg-[#0b0e13] dark:border-gray-700 dark:text-gray-100 dark:placeholder-gray-400"
                    required
                  />
                  <button
                    type="button"
                    onClick={() => setShowPwd((v) => !v)}
                    aria-label={showPwd ? "Ocultar contraseña" : "Mostrar contraseña"}
                    className="absolute right-3 top-2.5 text-gray-400 hover:text-gray-600 dark:hover:text-gray-300"
                  >
                    {showPwd ? <FiEyeOff className="w-5 h-5" /> : <FiEye className="w-5 h-5" />}
                  </button>
                </div>
                {errors.password && (
                  <p className="mt-2 text-sm text-red-600 dark:text-red-400">{errors.password}</p>
                )}
              </div>

              {/* Remember + Forgot */}
              <div className="flex items-center justify-between">
                <label className="inline-flex items-center gap-2 select-none">
                  <input
                    type="checkbox"
                    name="remember"
                    checked={data.remember}
                    onChange={(e) => setData("remember", e.target.checked)}
                    className="h-4 w-4 rounded border-gray-300 text-primary-700
                               focus:ring-2 focus:ring-primary-600 focus:ring-offset-0
                               dark:bg-[#0b0e13] dark:border-gray-700"
                  />
                  <span className="text-sm text-gray-700 dark:text-gray-300">Recordarme</span>
                </label>

                {canResetPassword && (
                  <Link
                    href={route("password.request")}
                    className="text-sm font-medium text-secondary-700 hover:text-secondary-800
                               dark:text-primary-200 dark:hover:text-white"
                  >
                    ¿Olvidaste tu contraseña?
                  </Link>
                )}
              </div>

              {/* Botón principal — solo primary */}
              <div className="pt-1">
                <button
                  type="submit"
                  disabled={processing}
                  className="w-full inline-flex items-center justify-center gap-2 rounded-lg px-4 py-2.5
                             font-semibold text-white bg-primary-700 hover:bg-primary-800
                             focus:outline-none focus:ring-2 focus:ring-primary-600
                             disabled:opacity-60 disabled:cursor-not-allowed
                             dark:bg-primary-800 dark:hover:bg-primary-700"
                >
                  <FiLogIn />
                  {processing ? "Ingresando..." : "Ingresar"}
                </button>
              </div>

              {/* Registro / Solicitud de acceso — solo secondary en link */}
              <p className="text-center text-sm text-gray-600 mt-1 dark:text-gray-300">
                ¿No tienes cuenta?{" "}
                <Link
                  href={route("register")}
                  className="font-semibold text-secondary-700 hover:text-secondary-800
                             dark:text-primary-200 dark:hover:text-white"
                >
                  Solicitar acceso
                </Link>
              </p>
            </form>
          </div>
        </div>
      </section>
    </PublicLayout>
  );
}
