import defaultTheme from 'tailwindcss/defaultTheme';
import forms from '@tailwindcss/forms';

/** @type {import('tailwindcss').Config} */
export default {
    darkMode: 'class',

    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/views/**/*.blade.php',
        './resources/js/**/*.jsx',
    ],

    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                primary: {
                    DEFAULT: '#100772', // Azul base profundo
                    50:  '#f2f2fa',
                    100: '#d9d8f3',
                    200: '#b1aee7',
                    300: '#847fd6',
                    400: '#5247c0',
                    500: '#2b1ca0',   // primary-light
                    600: '#1d127a',
                    700: '#150d5b',
                    800: '#0f0842',
                    900: '#0a052e',
                    950: '#050218',
                },
                secondary: {
                    DEFAULT: '#1E90FF', // Azul brillante
                    50:  '#f0f8ff',
                    100: '#d6ecff',
                    200: '#add8ff',
                    300: '#7cc0ff',
                    400: '#4aa6ff',
                    500: '#1e90ff',   // secondary
                    600: '#0f6fd6',
                    700: '#0a54a6',
                    800: '#073a73',
                    900: '#042246',
                    950: '#021126',
                },
            },
        },
    },

    plugins: [forms],
};
