<?php


use App\Http\Controllers\Admin\AdminUserController;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::middleware(['auth'])->group(function () {
    Route::get('/perfil', [AdminUserController::class, 'index'])->name('update.index');
    Route::patch('/perfil/{user}', [AdminUserController::class, 'update'])->name('update.update');

});

Route::get('/dashboard', function () {
    return Inertia::render('Dashboard');
});




require __DIR__.'/auth.php';
require __DIR__.'/landing.php';
require __DIR__.'/dashboard.php';
require __DIR__.'/usuarios.php';
require __DIR__.'/pregrados.php';
require __DIR__.'/postgrados.php';
require __DIR__.'/docentes.php';
require __DIR__.'/laboratorios.php';
require __DIR__.'/autoridades.php';
require __DIR__.'/lineas_investigacion.php';
require __DIR__.'/publicaciones.php';
require __DIR__.'/tic.php';
require __DIR__.'/pasantias.php';
require __DIR__.'/proyectos_investigacion.php';
