<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminUsuarioController;

// ===============================
// RUTAS PANEL ADMIN - USUARIOS
// ===============================
Route::middleware(['auth', 'verified'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {

        Route::get('usuarios', [AdminUsuarioController::class, 'index'])->name('usuarios.index');
        Route::post('usuarios', [AdminUsuarioController::class, 'store'])->name('usuarios.store');
        Route::patch('usuarios/{user}', [AdminUsuarioController::class, 'update'])->name('usuarios.update');
        Route::delete('usuarios/{user}', [AdminUsuarioController::class, 'destroy'])->name('usuarios.destroy');
        Route::patch('usuarios/{id}/restore', [AdminUsuarioController::class, 'restore'])->name('usuarios.restore');
        Route::delete('usuarios/{id}/force', [AdminUsuarioController::class, 'forceDestroy'])->name('usuarios.force');
        Route::patch('usuarios/{user}/toggle-status', [AdminUsuarioController::class, 'toggleStatus'])->name('usuarios.toggle');
    });
