<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminTicController;

Route::prefix('admin')->middleware(['auth'])->group(function () {
    Route::get('tic', [AdminTicController::class, 'index'])->name('admin.tic.index');
    Route::post('tic', [AdminTicController::class, 'store'])->name('admin.tic.store');
    Route::patch('tic/{publicacion}', [AdminTicController::class, 'update'])->name('admin.tic.update');
    Route::delete('tic/{publicacion}', [AdminTicController::class, 'destroy'])->name('admin.tic.destroy');
    Route::patch('tic/{id}/restore', [AdminTicController::class, 'restore'])->name('admin.tic.restore');
    Route::delete('tic/{id}/force', [AdminTicController::class, 'forceDestroy'])->name('admin.tic.force');
});

