<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminPublicacionController;

Route::prefix('admin')->middleware(['auth'])->group(function () {
    Route::get('publicaciones', [AdminPublicacionController::class, 'index'])->name('admin.publicaciones.index');
    Route::post('publicaciones', [AdminPublicacionController::class, 'store'])->name('admin.publicaciones.store');
    Route::patch('publicaciones/{publicacion}', [AdminPublicacionController::class, 'update'])->name('admin.publicaciones.update');
    Route::delete('publicaciones/{publicacion}', [AdminPublicacionController::class, 'destroy'])->name('admin.publicaciones.destroy');
    Route::patch('publicaciones/{id}/restore', [AdminPublicacionController::class, 'restore'])->name('admin.publicaciones.restore');
    Route::delete('publicaciones/{id}/force', [AdminPublicacionController::class, 'forceDestroy'])->name('admin.publicaciones.force');
});

