<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminProyectoInvestigacionController;

Route::middleware(['auth', 'verified'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::get('proyectos',                [AdminProyectoInvestigacionController::class, 'index'])->name('proyectos.index');
        Route::post('proyectos',               [AdminProyectoInvestigacionController::class, 'store'])->name('proyectos.store');
        Route::patch('proyectos/{proyecto}',   [AdminProyectoInvestigacionController::class, 'update'])->name('proyectos.update');
        Route::delete('proyectos/{proyecto}',  [AdminProyectoInvestigacionController::class, 'destroy'])->name('proyectos.destroy');
        Route::patch('proyectos/{id}/restore', [AdminProyectoInvestigacionController::class, 'restore'])->name('proyectos.restore');
        Route::delete('proyectos/{id}/force',  [AdminProyectoInvestigacionController::class, 'forceDestroy'])->name('proyectos.force');
    });
