<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminPregradoController;

Route::middleware(['auth', 'verified'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        // ======================
        // 🔹 Gestión de Pregrados
        // ======================

        // Listar (con filtros, búsqueda, papelera)
        Route::get('pregrados', [AdminPregradoController::class, 'index'])
            ->name('pregrados.index');

        // Crear nuevo
        Route::post('pregrados', [AdminPregradoController::class, 'store'])
            ->name('pregrados.store');

        // Actualizar existente
        Route::patch('pregrados/{pregrado}', [AdminPregradoController::class, 'update'])
            ->name('pregrados.update');

        // Enviar a papelera (soft delete)
        Route::delete('pregrados/{pregrado}', [AdminPregradoController::class, 'destroy'])
            ->name('pregrados.destroy');

        // Restaurar desde papelera
        Route::patch('pregrados/{id}/restore', [AdminPregradoController::class, 'restore'])
            ->name('pregrados.restore');

        // Eliminación definitiva
        Route::delete('pregrados/{id}/force', [AdminPregradoController::class, 'forceDestroy'])
            ->name('pregrados.force');

        // Alternar visibilidad pública (mostrar/ocultar)
        Route::patch('pregrados/{pregrado}/toggle-visible', [AdminPregradoController::class, 'toggleVisible'])
            ->name('pregrados.toggle');
    });
