<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminPostgradoController;

Route::middleware(['auth', 'verified'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        // ======================
        // 🔹 Gestión de Postgrados
        // ======================

        // Listar (con filtros, búsqueda, papelera)
        Route::get('postgrados', [AdminPostgradoController::class, 'index'])
            ->name('postgrados.index');

        // Crear nuevo
        Route::post('postgrados', [AdminPostgradoController::class, 'store'])
            ->name('postgrados.store');

        // Actualizar existente
        Route::patch('postgrados/{postgrado}', [AdminPostgradoController::class, 'update'])
            ->name('postgrados.update');

        // Enviar a papelera (soft delete)
        Route::delete('postgrados/{postgrado}', [AdminPostgradoController::class, 'destroy'])
            ->name('postgrados.destroy');

        // Restaurar desde papelera
        Route::patch('postgrados/{id}/restore', [AdminPostgradoController::class, 'restore'])
            ->name('postgrados.restore');

        // Eliminación definitiva
        Route::delete('postgrados/{id}/force', [AdminPostgradoController::class, 'forceDestroy'])
            ->name('postgrados.force');

        // Alternar visibilidad pública (mostrar/ocultar)
        Route::patch('postgrados/{postgrado}/toggle-visible', [AdminPostgradoController::class, 'toggleVisible'])
            ->name('postgrados.toggle');
    });
