<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminLaboratorioController;

Route::middleware(['auth', 'verified'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {
        Route::get('laboratorios',            [AdminLaboratorioController::class, 'index'])->name('laboratorios.index');
        Route::post('laboratorios',           [AdminLaboratorioController::class, 'store'])->name('laboratorios.store');
        Route::patch('laboratorios/{laboratorio}', [AdminLaboratorioController::class, 'update'])->name('laboratorios.update');
        Route::delete('laboratorios/{laboratorio}',[AdminLaboratorioController::class, 'destroy'])->name('laboratorios.destroy');
        Route::patch('laboratorios/{id}/restore',  [AdminLaboratorioController::class, 'restore'])->name('laboratorios.restore');
        Route::delete('laboratorios/{id}/force',   [AdminLaboratorioController::class, 'forceDestroy'])->name('laboratorios.force');
    });
