<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminDocenteController;
use App\Http\Controllers\Docente\DocenteController;

Route::prefix('admin')->middleware(['auth','role:Administrador'])->group(function () {
    Route::get('docentes', [AdminDocenteController::class, 'index'])->name('admin.docentes.index');
    Route::post('docentes', [AdminDocenteController::class, 'store'])->name('admin.docentes.store');
    Route::patch('docentes/{docente}', [AdminDocenteController::class, 'update'])->name('admin.docentes.update');
    Route::delete('docentes/{docente}', [AdminDocenteController::class, 'destroy'])->name('admin.docentes.destroy');
    Route::patch('docentes/{id}/restore', [AdminDocenteController::class, 'restore'])->name('admin.docentes.restore');
    Route::delete('docentes/{id}/force', [AdminDocenteController::class, 'forceDestroy'])->name('admin.docentes.forceDestroy');
});


Route::middleware(['auth','role:Docente'])
    ->prefix('docente')
    ->name('docente.')
    ->group(function () {
        Route::get('perfil', [DocenteController::class, 'edit'])->name('perfil.edit');
        Route::patch('perfil', [DocenteController::class, 'update'])->name('perfil.update');
    });
