<?php
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminAutoridadController;

Route::prefix('admin')->middleware(['auth', 'verified'])->group(function () {
    Route::get('/autoridades',                [AdminAutoridadController::class, 'index'])->name('admin.autoridades.index');
    Route::post('/autoridades',               [AdminAutoridadController::class, 'store'])->name('admin.autoridades.store');
    Route::patch('/autoridades/{autoridad}',  [AdminAutoridadController::class, 'update'])->name('admin.autoridades.update');
    Route::delete('/autoridades/{autoridad}', [AdminAutoridadController::class, 'destroy'])->name('admin.autoridades.destroy');
    Route::patch('/autoridades/{id}/restore', [AdminAutoridadController::class, 'restore'])->name('admin.autoridades.restore');
    Route::delete('/autoridades/{id}/force',  [AdminAutoridadController::class, 'forceDestroy'])->name('admin.autoridades.force');
});
