import React from "react";
import { motion } from "framer-motion";
import PublicLayout from "@/Layouts/PublicLayout";

export default function Mision() {
  const valores = [
    {
      title: "Excelencia Académica",
      desc: "Buscamos la mejora continua en la enseñanza, investigación y vinculación con la sociedad.",
      icon: "🎓",
      gradient: "from-blue-500 to-cyan-500"
    },
    {
      title: "Innovación Tecnológica",
      desc: "Promovemos la creatividad, la investigación aplicada y el desarrollo de soluciones sostenibles.",
      icon: "⚙️",
      gradient: "from-purple-500 to-pink-500"
    },
    {
      title: "Compromiso Social",
      desc: "Formamos profesionales con conciencia ética, responsabilidad y vocación de servicio al país.",
      icon: "🤝",
      gradient: "from-orange-500 to-red-500"
    },
  ];

  return (
    <PublicLayout titulo={"Misión Institucional"}>
    <div className="min-h-screen bg-gradient-to-b from-white via-gray-50 to-white">
      {/* Hero Section Mejorado */}
      <section className="relative h-[70vh] flex items-center justify-center overflow-hidden">
        {/* Imagen de fondo con overlay */}
        <div
          className="absolute inset-0 bg-cover bg-center"
          style={{ backgroundImage: "url('/assets/images/fondo_16.png')" }}
        />
        <div className="absolute inset-0 bg-gradient-to-br from-blue-900/90 via-indigo-900/85 to-purple-900/90" />

        {/* Patrón decorativo */}
        <div className="absolute inset-0 opacity-10">
          <div className="absolute inset-0" style={{
            backgroundImage: `radial-gradient(circle at 2px 2px, white 1px, transparent 0)`,
            backgroundSize: '40px 40px'
          }} />
        </div>

        {/* Elementos flotantes decorativos */}
        <div className="absolute top-20 left-10 w-72 h-72 bg-blue-400 rounded-full blur-3xl opacity-20 animate-pulse" />
        <div className="absolute bottom-20 right-10 w-96 h-96 bg-purple-400 rounded-full blur-3xl opacity-20 animate-pulse" style={{ animationDelay: '1s' }} />

        {/* Contenido del Hero */}
        <div className="relative z-10 text-center text-white px-6 max-w-5xl mx-auto">
          <motion.div
            initial={{ opacity: 0, scale: 0.9 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.8, ease: [0.22, 1, 0.36, 1] }}
          >
            {/* Badge decorativo */}
            <motion.div
              initial={{ opacity: 0, y: 20 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.6, delay: 0.2 }}
              className="inline-block mb-6"
            >
              <div className="bg-white/10 backdrop-blur-sm rounded-full px-6 py-2 border border-white/20">
                <span className="text-sm font-semibold tracking-wide">IDENTIDAD INSTITUCIONAL</span>
              </div>
            </motion.div>

            {/* Título principal */}
            <motion.h1
              initial={{ opacity: 0, y: 30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.8, delay: 0.3 }}
              className="text-5xl sm:text-6xl lg:text-7xl font-black tracking-tight mb-6"
            >
              Nuestra Misión
            </motion.h1>

            {/* Subtítulo */}
            <motion.p
              initial={{ opacity: 0, y: 30 }}
              animate={{ opacity: 1, y: 0 }}
              transition={{ duration: 0.8, delay: 0.4 }}
              className="text-xl sm:text-2xl text-blue-100 max-w-3xl mx-auto leading-relaxed"
            >
              Comprometidos con la formación, la innovación y el desarrollo tecnológico al servicio del país
            </motion.p>

            {/* Línea decorativa */}
            <motion.div
              initial={{ opacity: 0, scaleX: 0 }}
              animate={{ opacity: 1, scaleX: 1 }}
              transition={{ duration: 0.8, delay: 0.6 }}
              className="mt-8 flex items-center justify-center gap-3"
            >
              <div className="h-1 w-20 rounded-full bg-gradient-to-r from-transparent via-white/60 to-white/60" />
              <div className="w-3 h-3 rounded-full bg-white/60" />
              <div className="h-1 w-20 rounded-full bg-gradient-to-r from-white/60 via-white/60 to-transparent" />
            </motion.div>
          </motion.div>
        </div>

        {/* Onda decorativa inferior */}
        <div className="absolute bottom-0 left-0 right-0">
          <svg className="w-full h-16 fill-white" viewBox="0 0 1200 120" preserveAspectRatio="none">
            <path d="M0,0V46.29c47.79,22.2,103.59,32.17,158,28,70.36-5.37,136.33-33.31,206.8-37.5C438.64,32.43,512.34,53.67,583,72.05c69.27,18,138.3,24.88,209.4,13.08,36.15-6,69.85-17.84,104.45-29.34C989.49,25,1113-14.29,1200,52.47V0Z" opacity=".25"></path>
            <path d="M0,0V15.81C13,36.92,27.64,56.86,47.69,72.05,99.41,111.27,165,111,224.58,91.58c31.15-10.15,60.09-26.07,89.67-39.8,40.92-19,84.73-46,130.83-49.67,36.26-2.85,70.9,9.42,98.6,31.56,31.77,25.39,62.32,62,103.63,73,40.44,10.79,81.35-6.69,119.13-24.28s75.16-39,116.92-43.05c59.73-5.85,113.28,22.88,168.9,38.84,30.2,8.66,59,6.17,87.09-7.5,22.43-10.89,48-26.93,60.65-49.24V0Z" opacity=".5"></path>
            <path d="M0,0V5.63C149.93,59,314.09,71.32,475.83,42.57c43-7.64,84.23-20.12,127.61-26.46,59-8.63,112.48,12.24,165.56,35.4C827.93,77.22,886,95.24,951.2,90c86.53-7,172.46-45.71,248.8-84.81V0Z"></path>
          </svg>
        </div>
      </section>

      {/* Sección de la Misión */}
      <section className="py-20 bg-white">
        <div className="max-w-6xl mx-auto px-6 lg:px-8">
          <motion.div
            initial={{ opacity: 0, y: 40 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.7, ease: [0.22, 1, 0.36, 1] }}
            viewport={{ once: true, amount: 0.3 }}
            className="relative"
          >
            {/* Decoración lateral */}
            <div className="absolute -left-4 top-0 bottom-0 w-1 bg-gradient-to-b from-blue-500 via-indigo-500 to-purple-500 rounded-full" />

            <div className="space-y-6">
              <div className="inline-block">
                <h2 className="text-4xl sm:text-5xl font-black text-gray-900 mb-2">
                  Misión del Departamento
                </h2>
                <div className="h-1.5 w-32 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full" />
              </div>

              <p className="text-xl text-gray-700 leading-relaxed max-w-5xl">
                El Departamento de Electrónica, Telecomunicaciones y Redes de Información (DETRI)
                de la Escuela Politécnica Nacional tiene como misión formar profesionales altamente
                capacitados en el campo de la ingeniería electrónica y las telecomunicaciones, con
                sólidos principios éticos, pensamiento crítico, espíritu innovador y compromiso con
                el desarrollo científico y tecnológico del Ecuador.
              </p>
            </div>
          </motion.div>
        </div>
      </section>

      {/* Valores Institucionales */}
      <section className="py-20 bg-gradient-to-b from-gray-50 to-white">
        <div className="max-w-7xl mx-auto px-6 lg:px-8">
          {/* Título de sección */}
          <motion.div
            initial={{ opacity: 0, y: 30 }}
            whileInView={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.6 }}
            viewport={{ once: true }}
            className="text-center mb-16"
          >
            <h2 className="text-4xl sm:text-5xl font-black text-gray-900 mb-4">
              Nuestros Valores
            </h2>
            <p className="text-xl text-gray-600 max-w-2xl mx-auto">
              Los pilares que guían nuestra labor académica y compromiso institucional
            </p>
          </motion.div>

          {/* Grid de tarjetas */}
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            {valores.map((valor, index) => (
              <motion.div
                key={valor.title}
                initial={{ opacity: 0, y: 40 }}
                whileInView={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.6, delay: index * 0.15 }}
                viewport={{ once: true, amount: 0.3 }}
                whileHover={{ y: -8 }}
                className="group relative"
              >
                {/* Card */}
                <div className="relative h-full p-8 rounded-2xl bg-white border border-gray-200 shadow-lg hover:shadow-2xl transition-all duration-300 overflow-hidden">
                  {/* Gradiente decorativo superior */}
                  <div className={`absolute top-0 left-0 right-0 h-2 bg-gradient-to-r ${valor.gradient}`} />

                  {/* Fondo decorativo en hover */}
                  <div className={`absolute inset-0 bg-gradient-to-br ${valor.gradient} opacity-0 group-hover:opacity-5 transition-opacity duration-300`} />

                  {/* Contenido */}
                  <div className="relative z-10">
                    {/* Icono con fondo */}
                    <div className="mb-6 inline-flex items-center justify-center">
                      <div className={`w-20 h-20 rounded-2xl bg-gradient-to-br ${valor.gradient} flex items-center justify-center text-4xl shadow-lg transform group-hover:scale-110 group-hover:rotate-3 transition-all duration-300`}>
                        {valor.icon}
                      </div>
                    </div>

                    {/* Título */}
                    <h3 className="text-2xl font-bold text-gray-900 mb-3 group-hover:text-transparent group-hover:bg-clip-text group-hover:bg-gradient-to-r group-hover:from-blue-600 group-hover:to-purple-600 transition-all duration-300">
                      {valor.title}
                    </h3>

                    {/* Descripción */}
                    <p className="text-gray-600 leading-relaxed">
                      {valor.desc}
                    </p>
                  </div>

                  {/* Borde animado */}
                  <div className="absolute inset-0 rounded-2xl ring-2 ring-transparent group-hover:ring-indigo-500/50 transition-all duration-300" />
                </div>
              </motion.div>
            ))}
          </div>
        </div>
      </section>

      {/* Sección final decorativa */}
      <section className="py-16 bg-gradient-to-br from-blue-600 via-indigo-600 to-purple-700">
        <div className="max-w-4xl mx-auto px-6 text-center">
          <motion.div
            initial={{ opacity: 0, scale: 0.9 }}
            whileInView={{ opacity: 1, scale: 1 }}
            transition={{ duration: 0.7 }}
            viewport={{ once: true }}
          >
            <div className="inline-flex items-center justify-center w-16 h-16 rounded-2xl bg-white/10 backdrop-blur-sm border border-white/20 mb-6">
              <span className="text-3xl">🎯</span>
            </div>
            <h3 className="text-3xl sm:text-4xl font-black text-white mb-4">
              Construyendo el Futuro
            </h3>
            <p className="text-xl text-blue-100 leading-relaxed">
              Cada día trabajamos para cumplir nuestra misión y formar profesionales que transformen la sociedad ecuatoriana
            </p>
          </motion.div>
        </div>
      </section>
    </div>
    </PublicLayout>
  );
}
