// resources/js/Components/HeroDetri.jsx
import React, { useEffect, useRef } from "react";
import { motion } from "framer-motion";
import { Link } from "@inertiajs/react";
import { FiArrowRight } from "react-icons/fi";

export default function HeroDetri() {
  const videoRef = useRef(null);

  useEffect(() => {
    const video = videoRef.current;
    if (!video) return;

    const START_AT = 3; // recortar los primeros 3s
    let END_AT = null;  // se define tras conocer la duración

    const onLoadedMetadata = () => {
      // Si el video es más corto que 6s no recortamos (evita bucles raros)
      if (!video.duration || video.duration <= 6) return;

      END_AT = video.duration - 3; // recortar los últimos 3s
      // saltamos al inicio del segmento útil
      video.currentTime = START_AT;
      // por si algún navegador pausa al hacer seek antes de reproducir
      const playPromise = video.play?.();
      if (playPromise && typeof playPromise.then === "function") {
        playPromise.catch(() => {/* ignore autoplay block if any */});
      }
    };

    const onTimeUpdate = () => {
      if (!END_AT) return;
      if (video.currentTime >= END_AT) {
        // volvemos a 3s para mantener el loop dentro del rango
        video.currentTime = START_AT;
        video.play();
      }
    };

    video.addEventListener("loadedmetadata", onLoadedMetadata);
    video.addEventListener("timeupdate", onTimeUpdate);

    return () => {
      video.removeEventListener("loadedmetadata", onLoadedMetadata);
      video.removeEventListener("timeupdate", onTimeUpdate);
    };
  }, []);

  return (
    <section className="relative w-full h-[90vh] flex items-center justify-center overflow-hidden">
      {/* Video de fondo */}
      <video
        ref={videoRef}
        className="absolute inset-0 w-full h-full object-cover"
        autoPlay
        muted
        playsInline
        preload="auto"
        // IMPORTANTE: sin loop nativo; lo controlamos nosotros
        // loop
      >
        <source src="/assets/videos/Banner.mp4" type="video/mp4" />
        Tu navegador no soporta el video en HTML5.
      </video>

      {/* Overlay con gradiente */}
      <div className="absolute inset-0 bg-gradient-to-b from-black/10 via-black/10 to-black/20" />

      {/* Contenido */}
      <div className="relative z-10 max-w-5xl px-6 text-center text-white">
    <motion.h1
  initial={{ opacity: 0, y: 30 }}
  animate={{ opacity: 1, y: 0 }}
  transition={{ duration: 1 }}
  className="text-4xl sm:text-5xl lg:text-6xl font-extrabold leading-tight
             text-white drop-shadow-[0_6px_12px_rgba(0,0,0,8)]"
>
  Departamento de Electrónica, <br />
  Telecomunicaciones y Redes de Información
</motion.h1>

<motion.p
  initial={{ opacity: 0, y: 20 }}
  animate={{ opacity: 1, y: 0 }}
  transition={{ delay: 0.3, duration: 1 }}
  className="mt-6 text-lg sm:text-xl lg:text-2xl text-gray-200
             drop-shadow-[0_1px_3px_rgba(0,0,0,18)]"
>
  Innovación, investigación y formación académica de excelencia al
  servicio del Ecuador.
</motion.p>


        <motion.div
          initial={{ opacity: 0, y: 15 }}
          animate={{ opacity: 1, y: 0 }}
          transition={{ delay: 0.6, duration: 1 }}
          className="mt-8 flex justify-center"
        >
          <Link
            href="/oferta/pregrado"
            className="inline-flex items-center gap-2 px-6 py-3 rounded-xl text-lg font-semibold
                       bg-primary-600 hover:bg-primary-700 transition-colors
                       focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-primary-400"
          >
            Conoce nuestros programas <FiArrowRight />
          </Link>
        </motion.div>
      </div>

      {/* Indicador scroll */}
      <motion.div
        className="absolute bottom-6 left-1/2 -translate-x-1/2 text-white/70 text-sm"
        initial={{ opacity: 0 }}
        animate={{ opacity: 1, y: [0, 8, 0] }}
        transition={{ duration: 2, repeat: Infinity, ease: "easeInOut" }}
      >
        Desplázate
      </motion.div>
    </section>
  );
}
