import React, { useEffect } from "react";
import { Head, router } from "@inertiajs/react";
import AuthenticatedLayout from "@/Layouts/AuthenticatedLayout";

export default function Dashboard({ auth }) {
  useEffect(() => {
    const role = auth?.user?.role ?? "";

    // === Mapeo de destino por rol ===
    // Ajusta las rutas a las que ya tienes en tu app.
    let target;
    switch (role) {
      case "Administrador":
        // Panel principal de administración
        target = route("admin.usuarios.index");
        break;

      case "Secretaria":
        // Puedes dirigir a un módulo frecuente para Secretaría
        target = route("admin.usuarios.index"); // o route("admin.publicaciones.index"), etc.
        break;

      case "Docente":
        // Perfil del propio usuario (ya lo creamos)
        target = route("docente.index");
        break;

      default:
        // Fallback seguro: perfil propio
        target = route("admin.users.me.index");
        break;
    }

    // Evitar navegación innecesaria si ya estamos ahí
    if (target && window?.location?.pathname + window?.location?.search !== new URL(target, window.location.origin).pathname) {
      router.visit(target, { replace: true });
    }
  }, [auth?.user?.role]);

  return (
    <AuthenticatedLayout
      user={auth.user}
      header={<h2 className="font-semibold text-xl text-gray-800 leading-tight">Dashboard</h2>}
    >
      <Head title="Dashboard" />

      {/* Pantalla mínima mientras redirige */}
      <div className="py-12">
        <div className="max-w-7xl mx-auto sm:px-6 lg:px-8">
          <div className="bg-white overflow-hidden shadow-sm sm:rounded-lg">
            <div className="p-6 text-gray-900">
              Redirigiendo según tu rol…
            </div>
          </div>
        </div>
      </div>
    </AuthenticatedLayout>
  );
}
