// resources/js/Pages/Auth/Login.jsx
import React, { useEffect } from "react";
import { Head, useForm } from "@inertiajs/react";
import PublicLayout from "@/Layouts/PublicLayout";

export default function Login() {
  const { data, setData, post, processing, errors, reset } = useForm({
    email: "",
    password: "",
    remember: false,
  });

  useEffect(() => () => reset("password"), []);

  const submit = (e) => {
    e.preventDefault();
    post(route("login"));
  };

  return (
    <PublicLayout titulo="Iniciar Sesión">

      {/* Barra superior animada */}
      <div
        className="h-1 bg-gradient-to-r from-primary-500 via-secondary-500 to-primary-600 animate-[gradient-x_3s_ease_infinite]"

      />

      {/* Sección principal con menor padding */}
      <section className="relative  py-10 sm:py-12 flex items-center">
        {/* Fondo decorativo */}
        <div className="pointer-events-none absolute inset-0 -z-10">
          <div className="absolute inset-0 bg-white dark:bg-primary-950" />
          <div className="absolute inset-0 bg-[radial-gradient(ellipse_at_top,rgba(99,102,241,0.08),transparent_50%)] dark:bg-[radial-gradient(ellipse_at_top,rgba(99,102,241,0.12),transparent_50%)]" />
        </div>

        {/* Contenedor centrado */}
        <div className="mx-auto w-full max-w-md px-6 sm:px-8">
          {/* Encabezado */}
          <div className="text-center mb-6">
            <h1 className="text-2xl sm:text-3xl font-extrabold tracking-tight bg-gradient-to-r from-primary-700 to-secondary-600 dark:from-primary-200 dark:to-secondary-300 bg-clip-text text-transparent">
              Bienvenido a DETRI
            </h1>
            <p className="mt-1 text-sm text-primary-700/80 dark:text-primary-200/80">
              Ingresa con tus credenciales institucionales.
            </p>
          </div>

          {/* Card del formulario */}
          <div className="relative rounded-2xl border border-primary-200/60 bg-white/90 shadow-xl backdrop-blur dark:border-primary-800/60 dark:bg-primary-950/80">
            {/* Línea superior */}
            <div className="h-1 w-full bg-gradient-to-r from-primary-500 via-secondary-500 to-primary-600" />

            <form onSubmit={submit} className="p-6 sm:p-8">
              {/* Email */}
              <div>
                <label
                  htmlFor="email"
                  className="block text-sm font-medium text-primary-900 dark:text-primary-100"
                >
                  Correo institucional
                </label>
                <input
                  id="email"
                  type="email"
                  name="email"
                  value={data.email}
                  autoComplete="username"
                  autoFocus
                  onChange={(e) => setData("email", e.target.value)}
                  className="mt-1 block w-full rounded-xl border border-primary-200/70 bg-white/80 px-3 py-2 text-sm text-primary-900 placeholder-primary-400 shadow-sm outline-none transition focus:border-primary-400 focus:ring-2 focus:ring-primary-300/60 dark:border-primary-800/70 dark:bg-primary-900/40 dark:text-primary-50 dark:placeholder-primary-400"
                  placeholder="usuario@epn.edu.ec"
                />
                {errors.email && (
                  <p className="mt-2 text-sm text-red-600 dark:text-red-400">
                    {errors.email}
                  </p>
                )}
              </div>

              {/* Password */}
              <div className="mt-4">
                <label
                  htmlFor="password"
                  className="block text-sm font-medium text-primary-900 dark:text-primary-100"
                >
                  Contraseña
                </label>
                <input
                  id="password"
                  type="password"
                  name="password"
                  value={data.password}
                  autoComplete="current-password"
                  onChange={(e) => setData("password", e.target.value)}
                  className="mt-1 block w-full rounded-xl border border-primary-200/70 bg-white/80 px-3 py-2 text-sm text-primary-900 placeholder-primary-400 shadow-sm outline-none transition focus:border-primary-400 focus:ring-2 focus:ring-primary-300/60 dark:border-primary-800/70 dark:bg-primary-900/40 dark:text-primary-50 dark:placeholder-primary-400"
                  placeholder="••••••••"
                />
                {errors.password && (
                  <p className="mt-2 text-sm text-red-600 dark:text-red-400">
                    {errors.password}
                  </p>
                )}
              </div>

              {/* Remember me */}
              <div className="mt-4 flex items-center justify-start">
                <label className="inline-flex items-center gap-2 select-none">
                  <input
                    type="checkbox"
                    name="remember"
                    checked={data.remember}
                    onChange={(e) => setData("remember", e.target.checked)}
                    className="h-4 w-4 rounded border-primary-300 text-primary-600 focus:ring-primary-500 dark:border-primary-700 dark:bg-primary-900/40 dark:checked:bg-primary-600"
                  />
                  <span className="text-sm text-primary-700/90 dark:text-primary-200/90">
                    Recordarme
                  </span>
                </label>
              </div>

              {/* Botón principal */}
              <div className="mt-6">
                <button
                  type="submit"
                  disabled={processing}
                  className="relative inline-flex w-full items-center justify-center gap-2 rounded-xl px-4 py-2.5 text-sm font-semibold text-primary-900 transition disabled:opacity-70 dark:text-primary-100 focus:outline-none focus-visible:ring-2 focus-visible:ring-secondary-400"
                >
                  <span className="absolute inset-0 rounded-xl p-[1px] bg-gradient-to-r from-primary-500 via-secondary-500 to-primary-600" />
                  <span className="absolute inset-[1px] rounded-[11px] bg-white/95 backdrop-blur dark:bg-primary-950/90" />
                  <span className="relative z-10">
                    {processing ? "Ingresando..." : "Ingresar"}
                  </span>
                </button>
              </div>
            </form>
          </div>
        </div>
      </section>

      <style>{`
        @keyframes gradient-x {
          0%, 100% { background-position: 0% 50%; }
          50% { background-position: 100% 50%; }
        }
      `}</style>
    </PublicLayout>
  );
}
