import React, { useEffect } from "react";
import { useForm, router } from "@inertiajs/react";
import DashboardLayout from "@/Layouts/AuthenticatedLayout";

export default function MyProfile({ auth, user, flash }) {
  const { data, setData, errors, processing, reset } = useForm({
    name: user?.name ?? "",
    email: user?.email ?? "",
    current_password: "",
    password: "",
    password_confirmation: "",
  });

  useEffect(() => {
    if (flash?.success) console.log("✅", flash.success);
    if (flash?.error) console.error("❌", flash.error);
  }, [flash]);

  const submit = (e) => {
    e.preventDefault();
    router.patch(route("admin.users.me.update"), data, {
      preserveScroll: true,
      onSuccess: () => {
        // limpia campos sensibles
        reset("current_password", "password", "password_confirmation");
      },
    });
  };

  return (
    <DashboardLayout auth={auth} titulo="Mi perfil">
      <div className="mx-auto max-w-3xl rounded-2xl border border-primary-200/60 bg-white/90 p-6 shadow-sm backdrop-blur dark:border-primary-800/60 dark:bg-primary-950/80">
        <form onSubmit={submit} className="space-y-6">
          <h1 className="text-xl font-extrabold tracking-tight bg-gradient-to-r from-primary-700 to-secondary-600 bg-clip-text text-transparent dark:from-primary-200 dark:to-secondary-300">
            Información de cuenta
          </h1>

          {/* Datos básicos */}
          <div className="grid grid-cols-1 gap-4 sm:grid-cols-2">
            <div>
              <label className="block text-sm font-semibold">Nombre</label>
              <input
                type="text"
                value={data.name}
                onChange={(e) => setData("name", e.target.value)}
                className="mt-1 w-full rounded-xl border border-primary-200/60 bg-white/90 px-3 py-2 text-sm dark:border-primary-800/60 dark:bg-primary-950/80"
              />
              {errors.name && <p className="text-sm text-red-500">{errors.name}</p>}
            </div>

            <div>
              <label className="block text-sm font-semibold">Email</label>
              <input
                type="email"
                value={data.email}
                onChange={(e) => setData("email", e.target.value)}
                className="mt-1 w-full rounded-xl border border-primary-200/60 bg-white/90 px-3 py-2 text-sm dark:border-primary-800/60 dark:bg-primary-950/80"
              />
              {errors.email && <p className="text-sm text-red-500">{errors.email}</p>}
            </div>
          </div>

          {/* Cambiar contraseña (opcional) */}
          <div>
            <h2 className="mb-2 text-sm font-bold text-primary-700 dark:text-primary-200">
              Cambiar contraseña (opcional)
            </h2>
            <div className="grid grid-cols-1 gap-4 sm:grid-cols-3">
              <div className="sm:col-span-1">
                <label className="block text-sm font-semibold">Contraseña actual</label>
                <input
                  type="password"
                  value={data.current_password}
                  onChange={(e) => setData("current_password", e.target.value)}
                  placeholder="••••••••"
                  className="mt-1 w-full rounded-xl border border-primary-200/60 bg-white/90 px-3 py-2 text-sm dark:border-primary-800/60 dark:bg-primary-950/80"
                />
                {errors.current_password && (
                  <p className="text-sm text-red-500">{errors.current_password}</p>
                )}
              </div>

              <div className="sm:col-span-1">
                <label className="block text-sm font-semibold">Nueva contraseña</label>
                <input
                  type="password"
                  value={data.password}
                  onChange={(e) => setData("password", e.target.value)}
                  placeholder="Mínimo 8 caracteres"
                  className="mt-1 w-full rounded-xl border border-primary-200/60 bg-white/90 px-3 py-2 text-sm dark:border-primary-800/60 dark:bg-primary-950/80"
                />
                {errors.password && <p className="text-sm text-red-500">{errors.password}</p>}
              </div>

              <div className="sm:col-span-1">
                <label className="block text-sm font-semibold">Confirmación</label>
                <input
                  type="password"
                  value={data.password_confirmation}
                  onChange={(e) => setData("password_confirmation", e.target.value)}
                  placeholder="Repite la nueva contraseña"
                  className="mt-1 w-full rounded-xl border border-primary-200/60 bg-white/90 px-3 py-2 text-sm dark:border-primary-800/60 dark:bg-primary-950/80"
                />
              </div>
            </div>

            <p className="mt-2 text-xs text-primary-500">
              Solo se actualizará la contraseña si completas los tres campos (actual, nueva y confirmación).
            </p>
          </div>

          {/* Footer */}
          <div className="mt-2 flex justify-end gap-2">
            <button
              type="submit"
              disabled={processing}
              className="rounded-xl bg-primary-600 px-4 py-2 text-sm font-semibold text-white transition hover:bg-primary-700 disabled:opacity-60"
            >
              {processing ? "Guardando..." : "Guardar cambios"}
            </button>
          </div>
        </form>
      </div>
    </DashboardLayout>
  );
}
