<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('tic_projects', function (Blueprint $table) {
            $table->id();

            // Datos básicos
            $table->string('nombre_proyecto', 255);
            $table->string('carrera', 150)->nullable();
            $table->string('profesor_cargo', 150)->nullable();
            $table->text('resumen')->nullable();

            // Campos académicos
            $table->string('semestre', 20)->nullable();
            $table->string('linea_investigacion', 255)->nullable();

            // Campos tipo JSON
            $table->json('areas_trabajo')->nullable();
            $table->json('asignaturas_relacionadas')->nullable();

            // Estado de publicación (borrador/publicado)
            $table->enum('estado', ['borrador', 'publicado'])->default('borrador');

            // Auditoría
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();
            $table->softDeletes();

            // Índices útiles
            $table->index(['carrera', 'profesor_cargo', 'semestre']);
            $table->index('estado');
            $table->index('linea_investigacion');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('tic_projects');
    }
};
