<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('pasantias', function (Blueprint $table) {
            $table->id();

            // Contenido principal
            $table->string('titulo', 180);
            $table->string('slug', 200)->unique();
            $table->string('empresa', 180)->index();

            // Atributos de oferta
            $table->enum('modalidad', ['Remoto', 'Presencial', 'Híbrido'])->index();
            $table->string('duracion', 80)->nullable();
            $table->string('carrera', 180)->index();
            $table->string('tipo', 100)->default('Pasantía'); // ej: Pasantía / Práctica Preprofesional

            // Fechas
            $table->date('fecha_inicio')->nullable();
            $table->date('fecha_maxima_postulacion')->nullable()->index();

            // Beneficios / requisitos
            $table->boolean('remunerado')->default(false)->index();
            $table->integer('monto_remuneracion')->nullable(); // en USD, mensual (si aplica)
            $table->unsignedSmallInteger('cupos')->default(1);

            $table->json('requisitos')->nullable();
            $table->json('beneficios')->nullable();

            // Publicación / estado
            $table->enum('estado', ['borrador', 'publicado'])->default('borrador')->index();
            $table->timestamp('published_at')->nullable();

            // Trazabilidad
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();

            $table->softDeletes();
            $table->timestamps();

            // Índices compuestos útiles
            $table->index(['estado', 'fecha_maxima_postulacion']);
            $table->index(['modalidad', 'carrera']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pasantias');
    }
};
