<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('publicaciones', function (Blueprint $table) {
            $table->id();

            // Campos principales
            $table->unsignedSmallInteger('anio'); // 2015..actual
            $table->enum('estado', ['publicado','en-prensa'])->default('publicado');
            $table->string('titulo');
            $table->string('autores');   // cadena autores
            $table->string('revista')->nullable();
            $table->string('editorial')->nullable(); // dominio/house
            $table->text('extracto')->nullable();

            // Métricas / enlaces
            $table->unsignedInteger('citado_por')->default(0);
            $table->unsignedSmallInteger('versiones')->default(1);
            $table->string('url')->nullable()->unique();

            // Trazabilidad
            $table->boolean('activo')->default(true);
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();
            $table->softDeletes();

            // Índices útiles
            $table->index(['anio','estado','activo']);
            $table->index(['revista']);
            $table->index(['editorial']);
            $table->index(['citado_por']);
        });

        // Unicidad lógica opcional: mismo título + año no debe repetirse
        Schema::table('publicaciones', function (Blueprint $table) {
            $table->unique(['titulo','anio']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('publicaciones');
    }
};
