<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('lineas_investigacion', function (Blueprint $table) {
            $table->id();

            // Identificador público (como "LPI-DETRI-2023-01") y slug para URL
            $table->string('uid')->unique();              // ej. "LPI-DETRI-2023-01"
            $table->string('slug')->unique();             // ej. "sistemas-de-internet-de-las-cosas"

            // Campos principales
            $table->string('nombre');                     // título
            $table->string('profesor');                   // investigador principal
            $table->string('codigo')->unique();           // ej. "RCIIV-105-2023"
            $table->date('fecha');                        // 2023-04-25
            $table->enum('tipo', ['Prioritaria','Linea'])->default('Linea');
            $table->text('descripcion')->nullable();

            // Estado y trazabilidad
            $table->boolean('activo')->default(true);

            // Trazabilidad (relación opcional con users)
            $table->foreignId('created_by')->nullable()->constrained('users')->nullOnDelete();
            $table->foreignId('updated_by')->nullable()->constrained('users')->nullOnDelete();

            $table->timestamps();
            $table->softDeletes();

            // Índices útiles para búsquedas
            $table->index(['tipo', 'activo']);
            $table->index(['nombre']);
            $table->index(['profesor']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('lineas_investigacion');
    }
};
