<?php

// database/migrations/2025_10_08_000000_create_postgrados_table.php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('postgrados', function (Blueprint $t) {
            $t->id();
            $t->string('slug')->unique();
            $t->string('nombre');
            $t->string('tipo')->default('Maestría');  // Maestría/Especialización/Doctorado
            $t->string('area')->nullable();

            // Coordinación
            $t->string('coordinador_nombre');
            $t->string('coordinador_email');
            $t->string('coordinador_foto')->nullable();

            // Info general
            $t->string('duracion')->nullable();
            $t->string('modalidad')->nullable();
            $t->string('titulo')->nullable();
            $t->string('resolucion_senescyt')->nullable();

            // Recursos
            $t->string('imagen_hero')->nullable();
            $t->string('malla_url')->nullable();
            $t->string('brochure_url')->nullable();
            $t->string('inscripciones_url')->nullable();

            // Texto y campos estructurados
            $t->text('resumen')->nullable();
            $t->json('objetivos')->nullable();
            $t->json('perfil_egreso')->nullable();
            $t->json('requisitos')->nullable();
            $t->json('costos')->nullable();      // {"matricula":200,"arancel":3800,"becas":"..."}
            $t->json('calendario')->nullable();  // {"convocatoria":"...","clases":"..."}
            $t->json('contactos')->nullable();   // {"telefono":"...","oficina":"...","horario":"..."}

            $t->boolean('published')->default(true);
            $t->timestamps();
            $t->softDeletes();
        });
    }
    public function down(): void {
        Schema::dropIfExists('postgrados');
    }
};
