<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('proyectos_investigacion', function (Blueprint $table) {
            $table->id();
            $table->string('titulo');

            $table->enum('linea_investigacion', [
                'Multimedia',
                'Redes de Información',
                'Seguridad y Privacidad en Tecnologías de la Información',
                'Sistemas de Internet de las Cosas',
                'Microondas, Propagación y Antenas',
                'Comunicaciones Inalámbricas',
                'Sistemas Distribuidos',
            ]);

            $table->string('profesor_a_cargo');
            $table->year('ano');
            $table->enum('estado', ['En Desarrollo', 'Completado'])->default('En Desarrollo');
            $table->text('descripcion');
            $table->json('keywords')->nullable();

            $table->timestamps();
            $table->softDeletes();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('proyectos_investigacion');
    }
};
