<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('autoridades', function (Blueprint $table) {
            $table->id();

            // Identificador legible/slug (opcional pero útil para rutas)
            $table->string('slug')->unique();

            // Clave de grupo (para filtros)
            $table->enum('grupo_key', ['jefatura','pregrado','posgrado','administrativo'])->index();
            // Etiqueta legible (como en el front)
            $table->string('grupo');

            // Datos principales
            $table->string('nombre');
            $table->string('cargo');
            $table->string('area')->nullable();

            // Contacto
            $table->string('email')->nullable()->index();
            $table->string('telefono')->nullable();

            // Horarios normalizados (como en el front)
            $table->string('horario_dias')->nullable();   // p.ej. "Lunes a Viernes"
            $table->string('horario_rango')->nullable();  // p.ej. "09h00 – 12h00"

            // Ubicación y foto
            $table->string('ubicacion')->nullable();
            $table->string('foto')->nullable();

            // Orden opcional para mostrar (por grupo)
            $table->unsignedInteger('orden')->default(0)->index();

            $table->timestamps();
            $table->softDeletes(); // por si necesitas ocultar sin borrar
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('autoridades');
    }
};
