<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('laboratorios', function (Blueprint $table) {
            $table->id();

            // id “humano” tipo slug que traes en tu JSON (telecom, redes, electronica)
            $table->string('slug')->unique();

            $table->string('nombre');
            $table->string('responsable')->nullable();
            $table->text('descripcion')->nullable();

            // Estructuras flexibles
            $table->json('ubicacion')->nullable();   // { edificio, piso, oficina }
            $table->json('asignaturas')->nullable(); // ["Redes I", ...]
            $table->json('imagenes')->nullable();    // ["/storage/labs/...", ...]

            $table->timestamps();
            $table->softDeletes(); // por si quieres papelera
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('laboratorios');
    }
};
