<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('docentes', function (Blueprint $table) {
            $table->id();
            $table->string('nombre');
            $table->string('grado')->nullable();
            $table->string('area')->nullable();
            $table->string('foto')->nullable();
            $table->string('email')->unique();

            // Campos tipo JSON para mantener estructura flexible
            $table->json('asignaturas')->nullable(); // array de strings
            $table->json('enlaces')->nullable();     // objeto con los links

            $table->timestamps();
            $table->softDeletes(); // opcional, por si deseas eliminaciones lógicas
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('docentes');
    }
};
