<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('pregrados', function (Blueprint $table) {
            $table->id();

            // Identificador público
            $table->string('slug')->unique();                  // p.ej. "ti", "telecomunicaciones", "seguridad-redes"

            // Datos principales
            $table->string('nombre');                          // "Ingeniería en Telecomunicaciones"
            $table->string('duracion')->nullable();            // "10 semestres"
            $table->string('modalidad')->nullable();           // "Presencial"
            $table->string('titulo')->nullable();              // "Ingeniero/a en ..."

            // Coordinador (campos normalizados para búsqueda)
            $table->string('coordinador_nombre')->nullable();  // "Dr. Carlos Mendoza"
            $table->string('coordinador_email')->nullable();   // "carlos@..."
            $table->string('coordinador_foto')->nullable();    // "/assets/...png"

            // Media y descripciones
            $table->string('imagen_hero')->nullable();         // "/assets/carreras/telecom_1.png"
            $table->string('foto_tarjeta')->nullable();
            $table->text('informacion')->nullable();
            $table->text('perfil')->nullable();

            // Documentos / links
            $table->string('malla_url')->nullable();           // "/assets/mallas/malla_tele.pdf"

            // Requisitos en JSON (lista de strings)
            $table->json('requisitos')->nullable();

            // Presentación / control
            $table->boolean('is_visible')->default(true);
            $table->unsignedSmallInteger('orden')->default(0);

            $table->softDeletes();
            $table->timestamps();

            $table->index(['is_visible', 'orden']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pregrados');
    }
};
