<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();

            $table->string('name');

            // OPCIÓN A (por defecto): email único absoluto (aunque el registro esté soft-deleted)
            $table->string('email')->unique();

            // OPCIÓN B (permitir reutilizar email si el anterior fue soft-deleted):
            // $table->string('email')->index();

            $table->timestamp('email_verified_at')->nullable();

            // role simple (puedes dejarlo abierto o restringir con CHECK más abajo)
            $table->string('role', 30)->default('Docente')->index();

            $table->string('password');

            // Estado
            $table->boolean('is_active')->default(true)->index();

            $table->rememberToken();

            $table->timestamps();
            $table->softDeletes(); // deleted_at (SoftDeletes)

            // Índice útil para listados por fecha
            $table->index('created_at');
        });

        // (OPCIONAL) Restringir roles válidos con CHECK (MySQL 8.0.16+, PostgreSQL ok)
        // Descomenta si tu motor lo soporta:
        /*
        DB::statement("
            ALTER TABLE users
            ADD CONSTRAINT chk_users_role
            CHECK (role IN ('Administrador','Secretaria','Docente'))
        ");
        */

        // (OPCIONAL) Si elegiste **OPCIÓN B** para email (sin unique),
        // crea un índice parcial por app (no soportado nativamente en MySQL),
        // manejarás la unicidad en validación con whereNull('deleted_at').
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Si agregaste el CHECK y tu motor lo requiere, elimínalo primero
        // try { DB::statement('ALTER TABLE users DROP CONSTRAINT chk_users_role'); } catch (\Throwable $e) {}

        Schema::dropIfExists('users');
    }
};
