<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * Campos que se pueden asignar en masa.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'role',
        'is_active',
    ];

    /**
     * Campos ocultos al serializar.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Tipos de datos (casts) para atributos.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'is_active' => 'boolean',
        'deleted_at' => 'datetime',
    ];

    /**
     * =========================
     *  SCOPES PERSONALIZADOS
     * =========================
     */

    // Usuarios activos
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Usuarios inactivos
    public function scopeInactive($query)
    {
        return $query->where('is_active', false);
    }

    // Filtrar por rol
    public function scopeRole($query, $role)
    {
        return $query->where('role', $role);
    }

    /**
     * =========================
     *  MÉTODOS ÚTILES
     * =========================
     */

    // Verifica si es administrador
    public function isAdmin(): bool
    {
        return $this->role === 'Administrador';
    }

    // Verifica si es secretaria
    public function isSecretaria(): bool
    {
        return $this->role === 'Secretaria';
    }

    // Verifica si es docente
    public function isDocente(): bool
    {
        return $this->role === 'Docente';
    }
}
