<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TicProject extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'tic_projects';

    protected $fillable = [
        'nombre_proyecto',
        'carrera',
        'profesor_cargo',
        'resumen',
        'semestre',
        'linea_investigacion',
        'areas_trabajo',
        'asignaturas_relacionadas',
        'estado',
        'created_by',
        'updated_by',
    ];

    protected $casts = [
        'areas_trabajo' => 'array',
        'asignaturas_relacionadas' => 'array',
    ];

    /* === RELACIONES === */

    public function creador()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function editor()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    /* === SCOPES === */

    public function scopePublicado($q)
    {
        return $q->where('estado', 'publicado');
    }

    public function scopeFiltro($q, $filters)
    {
        if (!empty($filters['carrera'])) {
            $q->where('carrera', $filters['carrera']);
        }
        if (!empty($filters['profesorCargo'])) {
            $q->where('profesor_cargo', $filters['profesorCargo']);
        }
        if (!empty($filters['semestre'])) {
            $q->where('semestre', $filters['semestre']);
        }
        if (!empty($filters['lineaInvestigacion'])) {
            $q->where('linea_investigacion', $filters['lineaInvestigacion']);
        }
        if (!empty($filters['asignaturaRelacionada'])) {
            $q->whereJsonContains('asignaturas_relacionadas', $filters['asignaturaRelacionada']);
        }
        if (!empty($filters['q'])) {
            $q->where(function ($sub) use ($filters) {
                $q = $filters['q'];
                $sub->where('nombre_proyecto', 'like', "%$q%")
                    ->orWhere('resumen', 'like', "%$q%")
                    ->orWhere('profesor_cargo', 'like', "%$q%")
                    ->orWhere('linea_investigacion', 'like', "%$q%");
            });
        }
        return $q;
    }
}
