<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProyectoInvestigacion extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'proyectos_investigacion';

    protected $fillable = [
        'titulo',
        'linea_investigacion',
        'profesor_a_cargo',
        'ano',
        'estado',
        'descripcion',
        'keywords',
    ];

    protected $casts = [
        'keywords' => 'array',
        'ano' => 'integer',
    ];

    /* ======================================
       ENUMS
       ====================================== */
    public const LINEAS_INVESTIGACION = [
        'Multimedia',
        'Redes de Información',
        'Seguridad y Privacidad en Tecnologías de la Información',
        'Sistemas de Internet de las Cosas',
        'Microondas, Propagación y Antenas',
        'Comunicaciones Inalámbricas',
        'Sistemas Distribuidos',
    ];

    public const ESTADOS = [
        'En Desarrollo',
        'Completado',
    ];

    /* ======================================
       HELPERS / ACCESSORS
       ====================================== */
    public function getKeywordsListAttribute(): string
    {
        return $this->keywords ? implode(', ', $this->keywords) : '';
    }
}
