<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Pregrado extends Model
{
    use SoftDeletes;

    protected $table = 'pregrados';

    protected $fillable = [
        'slug',
        'nombre',
        'duracion',
        'modalidad',
        'titulo',
        'coordinador_nombre',
        'coordinador_email',
        'coordinador_foto',
        'imagen_hero',
        'foto_tarjeta',   // <— NUEVO
        'informacion',
        'perfil',
        // Usa uno u otro nombre según tu DB:
        'malla_url',      // si mantuviste malla_url
        // 'malla_archivo', // si renombraste
        'requisitos',
        'is_visible',
        'orden',
    ];

    protected $casts = [
        'requisitos' => 'array',
        'is_visible' => 'boolean',
        'orden'      => 'integer',
    ];

    public function scopeVisible($q)   { return $q->where('is_visible', true); }
    public function scopeOrdered($q)   { return $q->orderBy('orden')->orderBy('id'); }
    public function scopeSlug($q,$s)   { return $q->where('slug', $s); }
}
