<?php

// app/Models/Postgrado.php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Postgrado extends Model
{
    use SoftDeletes;

    protected $table = 'postgrados';

    protected $fillable = [
        'slug','nombre','tipo','area',
        'coordinador_nombre','coordinador_email','coordinador_foto',
        'duracion','modalidad','titulo','resolucion_senescyt',
        'imagen_hero','malla_url','brochure_url','inscripciones_url',
        'resumen','objetivos','perfil_egreso','requisitos','costos','calendario','contactos',
        'published',
    ];

    protected $casts = [
        'objetivos'     => 'array',
        'perfil_egreso' => 'array',
        'requisitos'    => 'array',
        'costos'        => 'array',
        'calendario'    => 'array',
        'contactos'     => 'array',
        'published'     => 'boolean',
    ];
}
