<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Str;

class Pasantia extends Model
{
    use SoftDeletes;

    protected $table = 'pasantias';

    protected $fillable = [
        'titulo','slug','empresa','modalidad','duracion','carrera','tipo',
        'fecha_inicio','fecha_maxima_postulacion',
        'remunerado','monto_remuneracion','cupos',
        'requisitos','beneficios',
        'estado','published_at',
        'created_by','updated_by',
    ];

    protected $casts = [
        'remunerado' => 'boolean',
        'cupos' => 'integer',
        'fecha_inicio' => 'date',
        'fecha_maxima_postulacion' => 'date',
        'published_at' => 'datetime',
        'requisitos' => 'array',
        'beneficios' => 'array',
    ];

    // Genera slug automáticamente
    protected static function booted()
    {
        static::creating(function ($model) {
            if (empty($model->slug)) {
                $model->slug = Str::slug(Str::limit($model->titulo, 180, ''));
            }
        });

        static::updating(function ($model) {
            if ($model->isDirty('titulo')) {
                $model->slug = Str::slug(Str::limit($model->titulo, 180, ''));
            }
        });
    }

    // Helpers
    public function scopePublicado($q) { return $q->where('estado', 'publicado'); }
    public function getEstaActivaAttribute(): bool
    {
        return $this->estado === 'publicado'
            && ($this->fecha_maxima_postulacion === null || $this->fecha_maxima_postulacion->isFuture());
    }
}
