<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;

class Laboratorio extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'laboratorios';

    protected $fillable = [
        'slug',
        'nombre',
        'responsable',
        'descripcion',
        'ubicacion',
        'asignaturas',
        'imagenes',
    ];

    protected $casts = [
        'ubicacion'   => 'array',
        'asignaturas' => 'array',
        'imagenes'    => 'array',
    ];

    /**
     * Helper opcional: devuelve URLs absolutas para las imágenes
     * (si guardas rutas tipo "/storage/...").
     */
    public function getImagenesUrlsAttribute(): array
    {
        $imgs = $this->imagenes ?? [];
        return array_map(function ($path) {
            // Si ya viene como URL absoluta, respétala
            if (is_string($path) && preg_match('/^https?:\/\//i', $path)) {
                return $path;
            }
            // Normaliza paths relativos
            return is_string($path) ? asset($path) : $path;
        }, $imgs);
    }
}
