<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Docente extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'docentes';

    protected $fillable = [
        'nombre',
        'grado',
        'area',
        'foto',
        'email',
        'asignaturas',
        'enlaces',
    ];

    // Los campos JSON se transforman automáticamente en arrays
    protected $casts = [
        'asignaturas' => 'array',
        'enlaces' => 'array',
    ];
}
