<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Autoridad extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'autoridades';

    protected $fillable = [
        'slug',
        'grupo_key',
        'grupo',
        'nombre',
        'cargo',
        'area',
        'email',
        'telefono',
        'horario_dias',
        'horario_rango',
        'ubicacion',
        'foto',
        'orden',
    ];

    protected $appends = ['horario']; // Combina días + rango como en el front

    protected $casts = [
        'orden' => 'integer',
    ];

    // Accessor para mostrar "Lunes a Viernes · 09h00 – 12h00"
    public function getHorarioAttribute(): ?string
    {
        $dias  = $this->horario_dias ?: null;
        $rango = $this->horario_rango ?: null;

        if ($dias && $rango) return "{$dias} · {$rango}";
        return $dias ?: $rango;
    }

    /* =========================
       SCOPES ÚTILES
       ========================= */
    public function scopeGrupoKey(Builder $q, string $grupoKey): Builder
    {
        return $q->where('grupo_key', $grupoKey);
    }

    public function scopeOrdenDefault(Builder $q): Builder
    {
        return $q->orderBy('grupo_key')->orderBy('orden')->orderBy('nombre');
    }
}
