<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Inertia\Inertia;
use Inertia\Response;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): Response
    {
        return Inertia::render('Auth/Register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|string|lowercase|email|max:255|unique:'.User::class,
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);

        $user = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'role' => 'Administrador',
            'password' => Hash::make($request->password),
        ]);

        event(new Registered($user));

        Auth::login($user);

         switch ($user->role) {
        case 'Administrador':
            return redirect()->route('admin.index'); // Ruta de admin
        case 'Secretaria':
            return redirect()->route('secretaria.index'); // Ruta de secretaria
        case 'Docente':
            return redirect()->route('docente.index'); // Ruta de docente
        default:
            return redirect()->route('dashboard'); // Ruta de usuarios normales
    }

    }
}
